#pragma once

#ifdef CSVDUMP_EXPORTS
#define CSVDUMP_API __declspec(dllexport)
#else
#define CSVDUMP_API __declspec(dllimport)
#endif

extern "C" CSVDUMP_API void Open(
	const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData);

extern "C" CSVDUMP_API void Close(
	const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData);

extern "C" CSVDUMP_API void PutFrameId(
	const unsigned int inSize, const unsigned int* inData,
	unsigned int* outSize, unsigned int** outData);

extern "C" CSVDUMP_API void PutTimeStamp(
	const unsigned int inSize, const unsigned int* inData,
	unsigned int* outSize, unsigned int** outData);

extern "C" CSVDUMP_API void PutError(
	const unsigned int inSize, const unsigned int* inData,
	unsigned int* outSize, unsigned int** outData);

extern "C" CSVDUMP_API void PutFrame(
	int type, int protocol, int channel, int status,
	const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData);

extern "C" CSVDUMP_API void PutString(
	const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData);

extern "C" CSVDUMP_API void Write(
	const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData);

