#include "pch.h" // use stdafx.h in Visual Studio 2017 and earlier
#include "CsvDump.h"
#include "Converter.h"
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#define BUF_SIZE 4096

static char cur[_MAX_PATH + 1] = "";	// dll current folder
static HANDLE out = INVALID_HANDLE_VALUE;
static char buf[BUF_SIZE * 2] = "";
static unsigned int pos = 0;

void Attach(HMODULE hModule)
{
	assert(*cur == '\0');

	char path[_MAX_PATH + 1];
	GetModuleFileName(hModule, path, sizeof(path));
	char drv[_MAX_DRIVE + 1] = "";
	char dir[_MAX_DIR + 1] = "";
	_splitpath(path, drv, dir, NULL, NULL);
	strcpy(cur, drv);
	strcat(cur, dir);
}

void Detach()
{
	if (out != INVALID_HANDLE_VALUE)
	{
		CloseHandle(out);
		out = INVALID_HANDLE_VALUE;
	}
	*cur = '\0';
	*buf = '\0';
}

// Open
void Open(const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData)
{
	static unsigned char res = 0;

	assert(*cur != '\0');
	for (res = 0; ; )
	{
		if (out != INVALID_HANDLE_VALUE)
		{
			// already open
			res = 3;
			break;
		}
		if (!(inSize > 0 && (strlen(cur) + inSize + 1) <= _MAX_PATH))
		{
			// parameter error
			res = 1;
			break;
		}

		char path[_MAX_PATH + 1] = "";
		char* p = path;
		strcpy(p, cur);
		p += strlen(cur);
		memcpy(p, inData, inSize);
		p += inSize;
		*p = '\0';
		out = CreateFile(path
			, GENERIC_WRITE
			, 0
			, NULL
			, CREATE_ALWAYS
			, FILE_ATTRIBUTE_NORMAL
			, NULL);
		if (out == INVALID_HANDLE_VALUE)
		{
			// open error
			res = 2;
		}
		break;
	}

	*outData = &res;
	*outSize = 1;
}

// Close
void Close(const unsigned int inSize, const unsigned char * inData,
	unsigned int * outSize, unsigned char ** outData)
{
	if (out != INVALID_HANDLE_VALUE)
	{
		CloseHandle(out);
		out = INVALID_HANDLE_VALUE;
	}
	*buf = '\0';

	*outSize = 0;
}

// frame id
void PutFrameId(const unsigned int inSize, const unsigned int * inData,
	unsigned int * outSize, unsigned int ** outData)
{
	if (inSize >= 1)
	{
		pos += sprintf(&buf[pos], "%09u", inData[0]);
		if (pos > BUF_SIZE)
			pos = BUF_SIZE;
	}

	*outSize = 0;
}

// time stamp
void PutTimeStamp(const unsigned int inSize, const unsigned int * inData,
	unsigned int * outSize, unsigned int ** outData)
{
	if (inSize >= 2)
	{
		char tmp[20];
		sprintf(tmp, "+%u.%06u", inData[0], inData[1]);
		tmp[9] = '\0';
		pos += sprintf(&buf[pos], ",%s", tmp);
		if (pos > BUF_SIZE)
			pos = BUF_SIZE;
	}

	*outSize = 0;
}

// error code
void PutError(const unsigned int inSize, const unsigned int * inData,
	unsigned int * outSize, unsigned int ** outData)
{
	if (inSize >= 1)
	{
		pos += sprintf(&buf[pos], ",(0:ERR=%08X)", inData[0]);
		if (pos > BUF_SIZE)
			pos = BUF_SIZE;
	}

	*outSize = 0;
}

// frame
void PutFrame(int type, int protocol, int channel, int status,
	const unsigned int inSize, const unsigned char * inData,
	unsigned int * outSize, unsigned char ** outData)
{
	unsigned int size = Convert(&buf[pos]
		, type, protocol, channel, status, inSize, inData);
	if (size == 0)
	{
		char* buf2 = &buf[pos];
		buf2 += sprintf(buf2, ",%04X,%02X,%02X,%X"
			, type, protocol, channel, status);
		unsigned int count = inSize;
		while (count-- > 0)
			buf2 += sprintf(buf2, ",%02X", *inData++);
		size = buf2 - &buf[pos];
	}
	pos += size;
	if (pos > BUF_SIZE)
		pos = BUF_SIZE;

	*outSize = 0;
}

// string
void PutString(const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData)
{
	assert(BUF_SIZE >= pos);

	unsigned int size = BUF_SIZE - pos;
	if (size > inSize)
		size = inSize;
	memcpy(&buf[pos], inData, size);
	pos += size;

	*outSize = 0;
}

// Write to output file
void Write(const unsigned int inSize, const unsigned char* inData,
	unsigned int* outSize, unsigned char** outData)
{
	static unsigned char res = 0;

	res = 0;
	buf[pos++] = '\r';
	buf[pos++] = '\n';
	DWORD written = 0;
	if (!WriteFile(out, buf, pos, &written, NULL))
	{
		// write error
		res = 1;
	}
	pos = 0;

	*outData = &res;
	*outSize = 1;
}
